/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	NewSketch.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT NewSketch(IWorkplane *workplane, int color, CString sketchName, ISketch **pSketch)
{
	/*
		Create new Sketch with the specified name on specified workplane and
		return the newly created sketch
	*/

	START_METHOD("NewSketch")

	HRESULT status = CONV_SUCCESS;

	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	if(color<0 || color>11)
		color = 4 ;

	// check if sketch name is not null
	if(sketchName.IsEmpty())
		AfxMessageBox("Sketch Name is NULL");

	// check if a sketch of the given name already exists

	ISketch *pSearchSketch= NULL;
	activeGraphicDoc->LookupSketch(sketchName.AllocSysString(), &pSearchSketch);

	ISketch *sketch= NULL;

	if(pSearchSketch == NULL)  {
		status = workplane->CreateSketch(sketchName.AllocSysString(), &sketch);
		CHECK_RETURN_STATUS(status)
	}
	else
		AfxMessageBox("A sketch already exists with that name.Please choose another name");

	// Set the color for the sketch
	IColor *pNewColor= NULL;
	status = (GetCLASS(Color))->CreateColor(1, color * 30, 0.35, 1,&pNewColor);

	CHECK_RETURN_STATUS(status)

	status = sketch->SetColor(pNewColor);
	CHECK_RETURN_STATUS(status)

	status = activeGraphicDoc->SetActiveSketch(sketch);
	CHECK_RETURN_STATUS(status)
	*pSketch = sketch;

	END_METHOD("NewSketch")
}
